% -------------------------------------------------------------- %
% vraca koeficijente polinoma koji u tackama x uzima vrednosti y %
% -------------------------------------------------------------- %

function L = LagranzovPolinom( x, y )

% koliko ima ulaznih argumenata
if nargin ~= 2
    error( 'Broj argumenata mora biti 2!!!' )
end

% dimenzije argumenata x i y
[mx, nx] = size( x );
[my, ny] = size( y );

% da li su x i y vektori?
if ( mx > 1 & nx > 1 ) | ( my > 1 & ny > 1 )
    error( 'x i y moraju biti vektori' )
% da li su vektori x i y iste duzine?
elseif length( x ) ~= length( y )
    error( 'Vektori x i y moraju biti iste dimenzije' ) 
end

% stepen polinoma
n = length( x ) - 1;  

% zbog kasnijeg sumiranja vektora, napunimo koeficijente L nulama
L = zeros( 1, n+1 );
% formiramo n+1 sabirak
for i = 1 : n+1
    p = 1;
    % za svako i formiramo proizvod od n cinilaca
    for j = 1 : n+1
        if i ~= j
            p = conv( p, [1 -x( j )] / ( x( i ) - x( j ) ) );
        end
    end
    % saberemo prethodni vektor sa dobijenim pomnozenim sa 
    % vrednosti f.je
    L = L + p * y( i );
end